/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.panel.pa;

import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.xfw.panel.CaptionValuePairing;
import com.ibm.hwmca.xfw.panel.pa.TypeSixBean;
import com.ibm.hwmca.xfw.panel.pa.XFramePanelUtils;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.Serializable;
import java.util.ArrayList;

public class PAPanelLIRBean
extends TypeSixBean {
    protected static final String[] OUTPUT_FIELD_NAMES = new String[]{"Output0", "Output1", "Output2", "Output3", "Output4"};
    protected static final String[][] NODE_FIELD_NAMES = new String[][]{{"Node1Output0", "Node1Output1", "Node1Output2", "Node1Output3"}, {"Node2RightOutput0", "Node2RightOutput1", "Node2RightOutput2", "Node2RightOutput3"}, {"Node2LeftOutput0", "Node2LeftOutput1", "Node2LeftOutput2", "Node2LeftOutput3"}, {"Node3Output0", "Node3Output01", "Node3Output02", "Node3Output03"}};
    protected static final String[] NODE_GROUP_NAMES = new String[]{"Node1GB", "Node2RightGB", "Node2LeftGB", "Node3GB"};
    protected String[] DISABLED_CONSTRUCTS = null;
    protected ArrayList problemDataContent = new ArrayList();
    protected ArrayList nodeContent = new ArrayList();
    protected LocalizableText[] description = null;
    protected LocalizableText[] correctiveAction = null;

    public void addNodeData(String title, ArrayList values) {
        this.nodeContent.add(new ContentElement(title, values));
    }

    public void addProblemData(CaptionValuePairing pairing) {
        this.problemDataContent.add(pairing);
    }

    public void setProblemDescription(LocalizableText[] description) {
        this.description = description;
    }

    public void setProblemDescription(LocalizableText description) {
        this.setProblemDescription(new LocalizableText[]{description});
    }

    public void setCorrectiveAction(LocalizableText[] correctiveAction) {
        this.correctiveAction = correctiveAction;
    }

    public void setCorrectiveAction(LocalizableText correctiveAction) {
        this.setCorrectiveAction(new LocalizableText[]{correctiveAction});
    }

    public void prepare() {
        System.out.println("{{PAPanelLIRBean}} prepare()");
        this.userTaskManager.setCaptionText("TypeSixPanel", "Problem Analysis");
        this.loadProblemData();
        this.loadProblemDescription();
        this.loadNodeData();
        this.loadCorrectiveAction();
        this.disableConstructs();
    }

    protected void disableConstructs() {
        for (int i = 0; this.DISABLED_CONSTRUCTS != null && i < this.DISABLED_CONSTRUCTS.length; ++i) {
            this.userTaskManager.setShown(this.getMountPrefix() + this.DISABLED_CONSTRUCTS[i], false);
        }
    }

    protected void loadNodeData() {
        int nodeContentSize = this.nodeContent.size();
        for (int i = 0; i < NODE_FIELD_NAMES.length; ++i) {
            if (i < nodeContentSize) {
                ContentElement ce = (ContentElement)this.nodeContent.get(i);
                int pairingCount = ce.pairings.size();
                this.userTaskManager.setCaptionText(NODE_GROUP_NAMES[i], ce.nodeName);
                this.userTaskManager.setShown(NODE_GROUP_NAMES[i], true);
                for (int j = 0; j < NODE_FIELD_NAMES[i].length; ++j) {
                    CaptionValuePairing pairing = (CaptionValuePairing)ce.pairings.get(i);
                    if (j < pairingCount) {
                        this.userTaskManager.setCaptionText(NODE_FIELD_NAMES[i][j], pairing.getCaption().toString());
                        this.m_nodeOutput[i][j] = ((Object)pairing.getValue()).toString();
                        continue;
                    }
                    this.userTaskManager.setCaptionText(NODE_FIELD_NAMES[i][j], "");
                    this.m_nodeOutput[i][j] = "";
                }
                continue;
            }
            this.userTaskManager.setShown(NODE_GROUP_NAMES[i], false);
        }
    }

    protected void loadProblemData() {
        int problemDataContentSize = this.problemDataContent.size();
        for (int i = 0; i < OUTPUT_FIELD_NAMES.length && i < problemDataContentSize; ++i) {
            CaptionValuePairing pairing = (CaptionValuePairing)this.problemDataContent.get(i);
            this.userTaskManager.setCaptionText(OUTPUT_FIELD_NAMES[i], pairing.getCaption().toString());
            this.m_output[i] = ((Object)pairing.getValue()).toString();
        }
        this.clearFields(OUTPUT_FIELD_NAMES.length - (OUTPUT_FIELD_NAMES.length - problemDataContentSize));
    }

    protected void loadProblemDescription() {
        if (this.description != null) {
            StringBuffer sb = new StringBuffer(128);
            for (int i = 0; i < this.description.length; ++i) {
                sb.append(this.description[i].toString() + " ");
            }
            this.m_sProblemOutput = sb.toString();
        } else {
            this.m_sProblemOutput = "";
        }
    }

    protected void loadCorrectiveAction() {
        if (this.correctiveAction != null) {
            StringBuffer sb = new StringBuffer(128);
            for (int i = 0; i < this.correctiveAction.length; ++i) {
                sb.append(this.correctiveAction[i].toString() + " ");
            }
            this.m_sCorrectiveActionOutput = sb.toString();
        } else {
            this.m_sCorrectiveActionOutput = "";
        }
    }

    protected void clearFields(int start) {
        for (int i = start; i < OUTPUT_FIELD_NAMES.length; ++i) {
            this.userTaskManager.setCaptionText(OUTPUT_FIELD_NAMES[i], "");
            this.m_output[i] = "";
        }
    }

    public void panelAction(TaskActionEvent event) {
        XFramePanelUtils.handleGenericAction(event, this);
    }

    protected class ContentElement
    implements Serializable {
        public String nodeName;
        public ArrayList pairings;

        public ContentElement(String nodeName, ArrayList pairings) {
            this.nodeName = nodeName;
            this.pairings = pairings;
        }
    }
}

